function [LogL,nu]=StaticTCopulaLL(theta,data,optimizer,method)
% The neggative log-likelihood of the static T Copula.
% The parameter theta is a scalar (degree of freedom parameter)
% IMPUTS:
% theta:            the degree of freedom parameter 
% data:             matrix of U(0,1) margins
% optimizer:        String with values 'fmincon' or 'fminunc'
% method:           String with values 'CML' or 'IFM'

% Warning:          If you want to estimate the parameters of your T
%                   Copula, you should run the function
%                   EstimateTVTCopula.m, which call this function

if nargin==3
    method='CML';
end
if min(min(data))<0 || max(max(data))>1
if strcmp(method,'IFM')==1
    data=normcdf(data);
end
if strcmp(method,'CML')==1
    data=empiricalCDF(data);
end
end
if min(min(data))<0
   error('data consists of U(0,1) margins')
end
if isscalar(theta)==0
    error('theta is a scalar')
end

if strcmp(optimizer,'fminunc')==1
nu=2.01+exp(theta);
elseif strcmp(optimizer,'fmincon')==1
nu=theta;    
end

rrho=corr(data,'type','kendall'); %since data is U(0,1) corr(data) is the rank correlation
rho=sin(.5*pi*rrho);
trdata=tinv(data,nu);

[T,N]=size(data);
Rt=repmat(rho,[1 1 T]);
% The T Copula likelihood function 
LL=zeros(T,1); 
for i=1:T
    LL(i) = gammaln((nu+N)/2) + (N-1)*gammaln(nu/2) - N*gammaln((nu+1)/2) - 0.5*log(det(Rt(:,:,i)));
    LL(i) = LL(i) - .5*(nu+N)*log(1+trdata(i,:)*inv(Rt(:,:,i))*trdata(i,:)'./nu);
    LL(i) = LL(i) + .5*(nu+1)*sum(log(1+(trdata(i,:).^2/nu)));
end
likelihood=sum(LL);
LogL=-likelihood;
